<?php
require 'conexion.php'; // Incluye el archivo de conexión

// Variables del formulario
$Corigen = $_POST['Corigen']; // Referencia del pedido
$vendedorNombre = 'Nombre del Vendedor'; // Este valor debería venir de otro formulario o sesión
$vendedorId = 1; // Este valor debería venir de otro formulario o sesión

// Consulta para obtener todas las líneas del pedido
$sql = "SELECT DISTINCT s.nom as Cliente, c.ref as Ref_Pedido, c.date_creation as Fecha_Creacion, 
        p.rowid as id_producto, p.label as Producto, cd.description as descripcion, cd.qty as Cantidad, 
        u.nom_unidad as Tipo_despacho, extra2.cantidad_despacho as Cantidad_Despacho
        FROM llx_societe as s 
        LEFT JOIN llx_c_departements as d ON s.fk_departement = d.rowid 
        LEFT JOIN llx_c_country as co ON s.fk_pays = co.rowid, 
        llx_commande as c 
        LEFT JOIN llx_projet as pj ON c.fk_projet = pj.rowid 
        LEFT JOIN llx_user as uc ON c.fk_user_author = uc.rowid 
        LEFT JOIN llx_user as uv ON c.fk_user_valid = uv.rowid 
        LEFT JOIN llx_commande_extrafields as extra ON c.rowid = extra.fk_object , 
        llx_commandedet as cd 
        LEFT JOIN llx_commandedet_extrafields as extra2 on cd.rowid = extra2.fk_object 
        LEFT JOIN llx_udd as u on  extra2.cestas = u.cod_unidad
        LEFT JOIN llx_product as p on cd.fk_product = p.rowid 
        LEFT JOIN llx_product_extrafields as extra3 on p.rowid = extra3.fk_object 
        WHERE c.fk_soc = s.rowid 
        AND c.rowid = cd.fk_commande
        AND c.entity IN (1)  
		AND c.fk_statut = 1 
        AND c.rowid = '$Corigen'";

$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Iterar sobre cada línea del pedido
    while ($row = $result->fetch_assoc()) {
        $Pcantidad = $row['Cantidad'];
        $Prowid = $row['id_producto'];

        // Insertar en llx_despacho_nuevo
        $sqlInsert = "INSERT INTO llx_despacho_nuevo (cliente, ref_pedido, fecha_creacion, producto, descripcion, cantidad, tipo_despacho, cantidad_despacho, usuario_sistema)
                      VALUES ('" . $row['Cliente'] . "', '$Corigen', NOW(), '" . $row['Producto'] . "', '" . $row['descripcion'] . "', $Pcantidad, '" . $row['Tipo_despacho'] . "', $Pcantidad, '$vendedorNombre')";
        if ($conn->query($sqlInsert) === TRUE) {
            echo "Registro insertado correctamente en llx_despacho_nuevo para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al insertar en llx_despacho_nuevo: " . $conn->error . "<br>";
        }

        // Update llx_product_stock
        $sqlUpdateStock = "UPDATE llx_product_stock SET reel = reel - $Pcantidad WHERE fk_product = $Prowid AND fk_entrepot = 4";
        if ($conn->query($sqlUpdateStock) === TRUE) {
            echo "Stock actualizado correctamente en llx_product_stock para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al actualizar llx_product_stock: " . $conn->error . "<br>";
        }

        // Update llx_product
        $sqlUpdateProduct = "UPDATE llx_product SET stock = stock - $Pcantidad WHERE rowid = $Prowid";
        if ($conn->query($sqlUpdateProduct) === TRUE) {
            echo "Stock actualizado correctamente en llx_product para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al actualizar llx_product: " . $conn->error . "<br>";
        }

        // Insertar en llx_stock_mouvement
        $sqlInsertMov = "INSERT INTO llx_stock_mouvement (fk_product, tms, datem, value, fk_entrepot, fk_user_author, label, type_mouvement, fk_origin, origintype)
                         VALUES ($Prowid, NOW(), NOW(), -$Pcantidad, 4, $vendedorId, 'Expedición por salida de producto del almacén', 2, '$Corigen', 'commande')";
        if ($conn->query($sqlInsertMov) === TRUE) {
            echo "Movimiento insertado correctamente en llx_stock_mouvement para el producto: " . $row['Producto'] . "<br>";
        } else {
            echo "Error al insertar en llx_stock_mouvement: " . $conn->error . "<br>";
        }
    }

    // Actualizar el estado del pedido en llx_commande
    $sqlUpdateCommande = "UPDATE llx_commande SET fk_statut = '3' WHERE rowid = '$Corigen'";
    if ($conn->query($sqlUpdateCommande) === TRUE) {
        echo "Estado del pedido actualizado correctamente en llx_commande.<br>";
    } else {
        echo "Error al actualizar el estado del pedido en llx_commande: " . $conn->error . "<br>";
    }

    echo "Despacho realizado con éxito para todas las líneas del pedido.";
} else {
    echo "No se encontraron líneas para el pedido: $Corigen";
}

// Cerrar la conexión
$conn->close();
?>